/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.reader;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.config.reader.ConfigReader;
import net.puffish.skillsmod.utils.PathUtils;

public class FileConfigReader
extends ConfigReader {
    private final Path modConfigDir;

    public FileConfigReader(Path modConfigDir) {
        this.modConfigDir = modConfigDir;
    }

    public Result<JsonElementWrapper, Failure> readFile(Path file) {
        PathUtils.createFileIfMissing(file);
        return JsonElementWrapper.parseFile(file, JsonPath.fromPath(this.modConfigDir.relativize(file)));
    }

    @Override
    public Result<JsonElementWrapper, Failure> read(Path path) {
        return this.readFile(this.modConfigDir.resolve(path));
    }

    @Override
    public boolean exists(Path path) {
        return Files.exists(this.modConfigDir.resolve(path), new LinkOption[0]);
    }
}

